
from gurobipy import *

# Create a new model
m = Model("LuggageProduction")

# Define variables
x1 = m.addVar(name="carry_on_suitcases", lb=0)
x2 = m.addVar(name="large_suitcases", lb=0)

# Set the objective function
m.setObjective(100*x1 + 150*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 15, name="carry_on_production_limit")
m.addConstr(x2 <= 20, name="large_suitcase_production_limit")
m.addConstr(x1 + x2 <= 25, name="sewing_machine_capacity")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal production: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: ${m.objVal}")
else:
    print("No optimal solution found")
