
import gurobi

def solve_luggage_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, ub=15, name="carry-on_suitcases")
    x2 = model.addVar(lb=0, ub=20, name="large_suitcases")

    # Define the objective function
    model.setObjective(100 * x1 + 150 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 + x2 <= 25, name="sewing_machine_capacity")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Carry-on suitcases: {x1.varValue}")
        print(f"Large suitcases: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_luggage_problem()
