
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Amazing_Decor")

# Create variables
furniture = m.addVar(vtype=GRB.INTEGER, name="furniture")
carpet = m.addVar(vtype=GRB.INTEGER, name="carpet")

# Set objective function
m.setObjective(40 * furniture + 30 * carpet, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12 * furniture + 7 * carpet <= 1200, "space_constraint")
m.addConstr(300 * furniture + 80 * carpet <= 30000, "budget_constraint")
m.addConstr(furniture >= 0.2 * (furniture + carpet), "furniture_ratio_constraint")
m.addConstr(furniture >= 0, "furniture_nonnegativity")
m.addConstr(carpet >= 0, "carpet_nonnegativity")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of furniture to buy: {furniture.x}")
    print(f"Number of carpets to buy: {carpet.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

