
from gurobipy import *

# Create a new model
m = Model("Amazing_Decor_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="furniture_items")
x2 = m.addVar(vtype=GRB.INTEGER, name="carpet_items")

# Set the objective function
m.setObjective(40*x1 + 30*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*x1 + 7*x2 <= 1200, "space_constraint")
m.addConstr(300*x1 + 80*x2 <= 30000, "budget_constraint")
m.addConstr(x1 >= 0.2*(x1 + x2), "furniture_proportion_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of furniture items: {x1.x}")
    print(f"Number of carpet items: {x2.x}")
else:
    print("No optimal solution found")
