
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="furniture", lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="carpet", lb=0, vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(40*x1 + 30*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(12*x1 + 7*x2 <= 1200, name="space_constraint")
    model.addConstr(300*x1 + 80*x2 <= 30000, name="budget_constraint")
    model.addConstr(4*x1 - x2 >= 0, name="furniture_percentage_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of furniture: {x1.varValue}")
        print(f"Number of carpet: {x2.varValue}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
