
import gurobi as gp
from gurobi import GRB

# Create a new model
m = gp.Model("EnergyDrinkCommercials")

# Define variables
x1 = m.addVar(name="famous_actors", vtype=GRB.INTEGER)  # Commercials with famous actors
x2 = m.addVar(name="regular_people", vtype=GRB.INTEGER)  # Commercials with regular people
x3 = m.addVar(name="no_people", vtype=GRB.INTEGER)     # Commercials with no people

# Objective function: Maximize viewership
m.setObjective(50000*x1 + 20000*x2 + 18000*x3, GRB.MAXIMIZE)

# Budget constraint
m.addConstr(10000*x1 + 3000*x2 + 2000*x3 <= 50000, name="budget_constraint")

# Constraint on commercials with regular actors
m.addConstr(x2 <= 3, name="regular_people_constraint")

# Constraint on commercials with no people
m.addConstr(2*x3 <= x1 + x2, name="no_people_constraint")

# Constraint on commercials with famous actors
m.addConstr(4*x1 >= x2 + x3, name="famous_actors_constraint")

# Non-negativity constraints are inherently handled by Gurobi for integer variables

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Commercials with famous actors: {x1.varValue}")
    print(f"Commercials with regular people: {x2.varValue}")
    print(f"Commercials with no people: {x3.varValue}")
    print(f"Max Viewership: {m.objVal}")
else:
    print("No optimal solution found")
