
import gurobipy as gp

# Create a new model
m = gp.Model("investment_optimization")

# Create variables
solar = m.addVar(name="solar")
wind = m.addVar(name="wind")
nuclear = m.addVar(name="nuclear")
coal = m.addVar(name="coal")

# Set objective function
m.setObjective(0.06 * solar + 0.09 * wind + 0.12 * nuclear + 0.03 * coal, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(solar + wind + nuclear + coal <= 1000000, "total_investment")
m.addConstr(coal <= solar, "coal_solar")
m.addConstr(wind <= nuclear, "wind_nuclear")
m.addConstr(coal <= 0.1 * 1000000, "coal_limit")


# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Solar Investment: ${solar.x}")
    print(f"Wind Investment: ${wind.x}")
    print(f"Nuclear Investment: ${nuclear.x}")
    print(f"Coal Investment: ${coal.x}")
    print(f"Total Return: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

