
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='solar', lb=0)
    x2 = model.addVar(name='wind', lb=0)
    x3 = model.addVar(name='nuclear', lb=0)
    x4 = model.addVar(name='coal', lb=0)

    # Objective function: maximize return
    model.setObjective(0.06*x1 + 0.09*x2 + 0.12*x3 + 0.03*x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 + x3 + x4 <= 1000000)  # Total investment
    model.addConstr(x4 <= x1)  # Coal vs Solar
    model.addConstr(x2 <= x3)  # Wind vs Nuclear
    model.addConstr(x4 <= 100000)  # Coal limit

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal investment:")
        print(f"Solar: ${x1.varValue:.2f}")
        print(f"Wind: ${x2.varValue:.2f}")
        print(f"Nuclear: ${x3.varValue:.2f}")
        print(f"Coal: ${x4.varValue:.2f}")
        print(f"Max Return: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
