
import gurobipy as gp

# Create a new model
model = gp.Model("Calculator Production")

# Create decision variables
solar = model.addVar(vtype=gp.GRB.CONTINUOUS, name="solar")
finance = model.addVar(vtype=gp.GRB.CONTINUOUS, name="finance")

# Set objective function
model.setObjective(12 * solar + 9 * finance, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5 * solar + 3 * finance <= 150, "silicon")
model.addConstr(4 * solar + 5 * finance <= 150, "plastic")
model.addConstr(2 * solar + 3 * finance <= 70, "steel")
model.addConstr(solar >= 0)
model.addConstr(finance >= 0)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"Solar calculators: {solar.x:.2f}")
    print(f"Finance calculators: {finance.x:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

