
from gurobipy import *

# Create a new model
m = Model("Calculator_Production")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="solar_calculators")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="finance_calculators")

# Set the objective function
m.setObjective(12*x1 + 9*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 3*x2 <= 150, "silicon_constraint")
m.addConstr(4*x1 + 5*x2 <= 150, "plastic_constraint")
m.addConstr(2*x1 + 3*x2 <= 70, "steel_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Production of solar calculators: {x1.x}")
    print(f"Production of finance calculators: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
