
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='solar_calculators', lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name='finance_calculators', lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(12 * x1 + 9 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5 * x1 + 3 * x2 <= 150, name='silicon_constraint')
    model.addConstr(4 * x1 + 5 * x2 <= 150, name='plastic_constraint')
    model.addConstr(2 * x1 + 3 * x2 <= 70, name='steel_constraint')

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Number of solar calculators: {x1.varValue}')
        print(f'Number of finance calculators: {x2.varValue}')
        print(f'Maximum profit: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
