
import gurobipy as gp

# Create a new model
m = gp.Model("Sausage_Mixture")

# Create variables
pork = m.addVar(lb=0, name="pork")  # kg of pork
chicken = m.addVar(lb=0, name="chicken")  # kg of chicken

# Set objective function
m.setObjective(40 * pork + 50 * chicken, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * pork + 3 * chicken >= 10, "Protein_Requirement")
m.addConstr(4 * pork + 2 * chicken >= 15, "Fat_Requirement")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Cost: ${m.objVal}")
    print(f"Pork: {pork.x} kg")
    print(f"Chicken: {chicken.x} kg")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

