
from gurobipy import *

# Create a new model
m = Model("Sausage_Mixture")

# Add variables to the model
x1 = m.addVar(lb=0, name="pork")
x2 = m.addVar(lb=0, name="chicken")

# Set the objective function
m.setObjective(40*x1 + 50*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x1 + 3*x2 >= 10, name="protein_constraint")
m.addConstr(4*x1 + 2*x2 >= 15, name="fat_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Pork: {x1.x} kg")
    print(f"Chicken: {x2.x} kg")
    print(f"Total Cost: ${m.objVal}")
else:
    print("No optimal solution found")

