
import gurobi

def solve_sausage_mixture_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="pork", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="chicken", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(40 * x1 + 50 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(2 * x1 + 3 * x2 >= 10, name="protein_constraint")
    model.addConstr(4 * x1 + 2 * x2 >= 15, name="fat_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal cost: ", model.objVal)
        print("Pork: ", x1.varValue, "kg")
        print("Chicken: ", x2.varValue, "kg")
    else:
        print("The model is infeasible")

solve_sausage_mixture_problem()
