
from gurobipy import Model, GRB

# Create a new model
m = Model("Joel's Diet")

# Create variables
chocolate_shakes = m.addVar(lb=0, name="Chocolate_Shakes")  # x1
meal_smoothies = m.addVar(lb=0, name="Meal_Smoothies")  # x2


# Set objective function
m.setObjective(8 * chocolate_shakes + 10 * meal_smoothies, GRB.MINIMIZE)

# Add constraints
m.addConstr(35 * chocolate_shakes + 15 * meal_smoothies >= 150, "Protein_Requirement")
m.addConstr(20 * chocolate_shakes + 25 * meal_smoothies >= 130, "Carb_Requirement")
m.addConstr(3 * chocolate_shakes + 10 * meal_smoothies <= 50, "Fat_Limit")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print(f"Optimal Cost: ${m.objVal:.2f}")
    print(f"Chocolate Protein Shakes: {chocolate_shakes.x:.2f} servings")
    print(f"Meal Replacement Smoothies: {meal_smoothies.x:.2f} servings")

