
from gurobipy import *

# Create a new model
m = Model("Joel_Diet")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chocolate_protein_shakes")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vanilla_meal_replacement_smoothies")

# Set the objective function
m.setObjective(8*x1 + 10*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(35*x1 + 15*x2 >= 150, "protein_constraint")
m.addConstr(20*x1 + 25*x2 >= 130, "carbs_constraint")
m.addConstr(3*x1 + 10*x2 <= 50, "fat_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Chocolate protein shakes: {x1.x}")
    print(f"Vanilla meal replacement smoothies: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
