
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="chocolate_protein_shakes")
    x2 = model.addVar(lb=0, name="vanilla_meal_replacement_smoothies")

    # Define the objective function
    model.setObjective(8*x1 + 10*x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(35*x1 + 15*x2 >= 150, name="protein_requirement")
    model.addConstr(20*x1 + 25*x2 >= 130, name="carbs_requirement")
    model.addConstr(3*x1 + 10*x2 <= 50, name="fat_limit")

    # Optimize the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of chocolate protein shakes: {x1.varValue}")
        print(f"Number of vanilla meal replacement smoothies: {x2.varValue}")
        print(f"Total cost: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

solve_optimization_problem()
