
import gurobipy as gp

# Create a new model
m = gp.Model("mattress_production")

# Create variables
queen = m.addVar(vtype=gp.GRB.CONTINUOUS, name="queen")  # Number of queen mattresses
king = m.addVar(vtype=gp.GRB.CONTINUOUS, name="king")  # Number of king mattresses


# Set objective function
m.setObjective(300 * queen + 500 * king, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * queen + 30 * king <= 5000, "foam_constraint")
m.addConstr(10 * queen + 15 * king <= 2500, "packaging_constraint")
m.addConstr(queen >= 0, "queen_nonnegativity")  # Ensure non-negative number of mattresses.
m.addConstr(king >= 0, "king_nonnegativity")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Queen Mattresses: {queen.x}")
    print(f"Number of King Mattresses: {king.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

