
from gurobipy import *

# Create a new model
m = Model("Mattress_Profit")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="queen_mattresses")
x2 = m.addVar(vtype=GRB.INTEGER, name="king_mattresses")

# Set the objective function
m.setObjective(300*x1 + 500*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 30*x2 <= 5000, "foam_constraint")
m.addConstr(10*x1 + 15*x2 <= 2500, "packaging_time_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Queen mattresses: {x1.x}")
    print(f"King mattresses: {x2.x}")
    print(f"Total profit: ${300*x1.x + 500*x2.x}")
else:
    print("No optimal solution found")
