
import gurobipy as gp

# Create a new model
model = gp.Model("Mattress_Production")

# Define the variables
x1 = model.addVar(name="queen_size", lb=0, vtype=gp.GRB.CONTINUOUS)  # Queen size mattresses
x2 = model.addVar(name="king_size", lb=0, vtype=gp.GRB.CONTINUOUS)  # King size mattresses

# Objective function: Maximize profit
model.setObjective(300*x1 + 500*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(20*x1 + 30*x2 <= 5000, name="foam_constraint")  # Foam constraint
model.addConstr(10*x1 + 15*x2 <= 2500, name="packaging_time_constraint")  # Packaging time constraint

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: Queen size mattresses = {x1.varValue}, King size mattresses = {x2.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
