
import gurobipy as gp

# Create a new model
m = gp.Model("investment_optimization")

# Create variables
investment_A = m.addVar(name="investment_A")
investment_B = m.addVar(name="investment_B")

# Set objective function
m.setObjective(0.09 * investment_A + 0.12 * investment_B, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(investment_A + investment_B <= 500000, "total_investment")
m.addConstr(investment_A >= 2 * investment_B, "investment_ratio")
m.addConstr(investment_B <= 200000, "investment_B_limit")
m.addConstr(investment_A >= 0, "investment_A_positive")  # Ensure non-negativity
m.addConstr(investment_B >= 0, "investment_B_positive")  # Ensure non-negativity


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment in Company A: ${investment_A.x}")
    print(f"Optimal investment in Company B: ${investment_B.x}")
    print(f"Maximum earnings: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

