
from gurobipy import *

# Create a model
m = Model("Investment_Optimization")

# Define variables
x1 = m.addVar(name='x1', lb=0)  # Amount invested in company A
x2 = m.addVar(name='x2', lb=0)  # Amount invested in company B

# Set the objective function
m.setObjective(0.09*x1 + 0.12*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 == 500000, name='total_investment')
m.addConstr(x1 >= 2*x2, name='investment_ratio')
m.addConstr(x2 <= 200000, name='max_investment_B')

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal investment in company A: {x1.x}")
    print(f"Optimal investment in company B: {x2.x}")
    print(f"Maximum earnings: {m.objVal}")
else:
    print("Model is not optimal")
