
import gurobipy as gp

# Create a new model
model = gp.Model("Investment_Optimization")

# Define variables
x1 = model.addVar(name="Investment_in_Company_A", lb=0)
x2 = model.addVar(name="Investment_in_Company_B", lb=0)

# Objective function: Maximize earnings
model.setObjective(0.09*x1 + 0.12*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 + x2 <= 500000, name="Total_Investment")
model.addConstr(x1 >= 2*x2, name="Investment_Ratio")
model.addConstr(x2 <= 200000, name="Max_Investment_in_Company_B")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment in Company A: ${x1.varValue:.2f}")
    print(f"Optimal investment in Company B: ${x2.varValue:.2f}")
    print(f"Maximized earnings: ${0.09*x1.varValue + 0.12*x2.varValue:.2f}")
else:
    print("The model is infeasible.")
