
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("gardening_company")

# Create variables
newcomers = m.addVar(lb=0, vtype=GRB.INTEGER, name="newcomers")
full_time = m.addVar(lb=0, vtype=GRB.INTEGER, name="full_time")

# Set objective function
m.setObjective(400 * newcomers + 700 * full_time, GRB.MINIMIZE)

# Add constraints
m.addConstr(newcomers + full_time >= 100, "total_gardeners")
m.addConstr(full_time >= 40, "min_full_time")
m.addConstr(full_time >= 0.5 * newcomers, "supervision_ratio")


# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal wage bill: ${m.objVal}")
    print(f"Number of newcomers: {newcomers.x}")
    print(f"Number of full-time employees: {full_time.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

