
from gurobipy import *

# Create a new model
m = Model("Gardening_Company")

# Define variables
x1 = m.addVar(name='newcomers', vtype=GRB.CONTINUOUS, lb=0)  # Number of newcomers
x2 = m.addVar(name='full_time_employees', vtype=GRB.CONTINUOUS, lb=0)  # Number of full-time employees

# Set the objective function: Minimize wage bill
m.setObjective(400*x1 + 700*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 + x2 >= 100, name='total_gardeners')  # Total gardeners should be at least 100
m.addConstr(x2 >= 40, name='min_full_time_employees')  # At least 40 full-time employees
m.addConstr(x2 >= 0.5*x1, name='full_time_newcomer_ratio')  # Full-time employees should be at least half the number of newcomers

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Number of newcomers: {x1.x}')
    print(f'Number of full-time employees: {x2.x}')
    print(f'Total wage bill: ${400*x1.x + 700*x2.x:.2f}')
else:
    print('No optimal solution found')
