
import gurobi

def solve_gardening_company_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='newcomers', lb=0, vtype=gurobi.GRB.INTEGER)  # Number of newcomers
    x2 = model.addVar(name='full_time_employees', lb=0, vtype=gurobi.GRB.INTEGER)  # Number of full-time employees

    # Objective function: Minimize the wage bill
    model.setObjective(400 * x1 + 700 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x1 + x2 >= 100, name='total_gardeners')  # At least 100 gardeners
    model.addConstr(x2 >= 40, name='min_full_time')  # At least 40 full-time employees
    model.addConstr(x2 >= 0.5 * x1, name='supervision_requirement')  # Full-time employees >= half of newcomers

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution:")
        print(f"Newcomers: {x1.varValue}")
        print(f"Full-time employees: {x2.varValue}")
        print(f"Minimum wage bill: ${400*x1.varValue + 700*x2.varValue}")
    else:
        print("The problem is infeasible.")

solve_gardening_company_problem()
