
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("engineer_hiring")

# Create variables
computer_engineers = m.addVar(lb=0, vtype=GRB.INTEGER, name="computer_engineers")
software_engineers = m.addVar(lb=0, vtype=GRB.INTEGER, name="software_engineers")

# Set objective function
m.setObjective(1000 * computer_engineers + 800 * software_engineers, GRB.MINIMIZE)

# Add constraints
m.addConstr(computer_engineers + software_engineers >= 50, "total_engineers")
m.addConstr(computer_engineers >= 10, "min_computer_engineers")
m.addConstr(software_engineers >= 2 * computer_engineers, "software_engineers_ratio")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: hire {computer_engineers.x} computer engineers and {software_engineers.x} software engineers")
    print(f"Total cost: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

