
from gurobipy import *

# Create a new model
m = Model("Optimize_Engineers")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="computer_engineers")
x2 = m.addVar(vtype=GRB.INTEGER, name="software_engineers")

# Set objective function
m.setObjective(1000*x1 + 800*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 + x2 >= 50, "total_engineers")
m.addConstr(x1 >= 10, "min_computer_engineers")
m.addConstr(x2 >= 2*x1, "software_to_computer_ratio")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Computer Engineers: {x1.x}")
    print(f"Software Engineers: {x2.x}")
    print(f"Total Cost: ${1000*x1.x + 800*x2.x}")
else:
    print("No optimal solution found")
