
import gurobipy as gp

def solve_engineer_hiring_problem():
    # Create a new model
    model = gp.Model("engineer_hiring")

    # Define variables
    x1 = model.addVar(name="computer_engineers", lb=0, vtype=gp.GRB.INTEGER)
    x2 = model.addVar(name="software_engineers", lb=0, vtype=gp.GRB.INTEGER)

    # Objective function: Minimize labor cost
    model.setObjective(1000*x1 + 800*x2, gp.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x1 + x2 >= 50, name="total_engineers")
    model.addConstr(x1 >= 10, name="min_computer_engineers")
    model.addConstr(x2 >= 2*x1, name="software_vs_computer")

    # Solve the model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Number of computer engineers: {x1.varValue}")
        print(f"Number of software engineers: {x2.varValue}")
        print(f"Minimum labor cost: ${model.objVal}")
    elif model.status == gp.GRB.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

solve_engineer_hiring_problem()
