
import gurobipy as gp

# Create a new model
m = gp.Model("breakfast_optimization")

# Create variables
pancakes = m.addVar(vtype=gp.GRB.CONTINUOUS, name="pancakes")
waffles = m.addVar(vtype=gp.GRB.CONTINUOUS, name="waffles")

# Set objective function
m.setObjective(5 * pancakes + 7 * waffles, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(30 * pancakes + 50 * waffles <= 5000, "flour_constraint")
m.addConstr(10 * pancakes + 15 * waffles <= 2000, "butter_constraint")
m.addConstr(pancakes >= 0, "pancakes_nonnegative")
m.addConstr(waffles >= 0, "waffles_nonnegative")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of pancakes: {pancakes.x}")
    print(f"Number of waffles: {waffles.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

