
from gurobipy import *

# Create a new model
model = Model("Breakfast_Diner")

# Define variables
x1 = model.addVar(vtype=GRB.CONTINUOUS, name="pancakes")
x2 = model.addVar(vtype=GRB.CONTINUOUS, name="waffles")

# Set the objective function
model.setObjective(5*x1 + 7*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(30*x1 + 50*x2 <= 5000, "flour_limit")
model.addConstr(10*x1 + 15*x2 <= 2000, "butter_limit")

# Solve the model
model.optimize()

# Print solution
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
