
import gurobipy as gp

# Create a new model
m = gp.Model("Pancakes_Waffles")

# Define the variables
x1 = m.addVar(name="pancakes", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = m.addVar(name="waffles", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define the objective function
m.setObjective(5*x1 + 7*x2, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(30*x1 + 50*x2 <= 5000, name="flour_constraint")
m.addConstr(10*x1 + 15*x2 <= 2000, name="butter_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Pancakes: {x1.varValue}")
    print(f"Waffles: {x2.varValue}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found.")
