
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("arcade_shooter")

# Create variables
ducks = m.addVar(vtype=GRB.INTEGER, name="ducks")
geese = m.addVar(vtype=GRB.INTEGER, name="geese")

# Set objective function
m.setObjective(5 * ducks + 6 * geese, GRB.MAXIMIZE)

# Add constraints
m.addConstr(ducks >= 5, "min_ducks")
m.addConstr(geese >= 3, "min_geese")
m.addConstr(ducks <= 12, "max_ducks")
m.addConstr(geese <= 7, "max_geese")
m.addConstr(ducks + geese <= 15, "total_shots")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: shoot {ducks.x} ducks and {geese.x} geese")
    print(f"Total points: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Infeasible solution")
else:
    print("Optimization terminated with status:", m.status)

