
from gurobipy import *

# Create a new model
m = Model("Arcade_Shooter")

# Define variables
x1 = m.addVar(lb=5, ub=12, vtype=GRB.INTEGER, name="ducks")
x2 = m.addVar(lb=3, ub=7, vtype=GRB.INTEGER, name="geese")

# Set the objective function
m.setObjective(5*x1 + 6*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 15, "total_animals")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {int(x1.x)}, {x2.varName} = {int(x2.x)}")
    print(f"Maximum points: {m.objVal}")
else:
    print("No optimal solution found")
