
import gurobi

def solve_arcade_shooter_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, name="ducks")
    x2 = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, name="geese")

    # Set objective function
    model.setObjective(5*x1 + 6*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 >= 5, name="min_ducks")
    model.addConstr(x2 >= 3, name="min_geese")
    model.addConstr(x1 <= 12, name="max_ducks")
    model.addConstr(x2 <= 7, name="max_geese")
    model.addConstr(x1 + x2 <= 15, name="total_animals")

    # Update model
    model.update()

    # Solve model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution:")
        print(f"Ducks: {x1.varValue}")
        print(f"Geese: {x2.varValue}")
        print(f"Max points: {5*x1.varValue + 6*x2.varValue}")
    else:
        print("No optimal solution found")

solve_arcade_shooter_problem()
