
from gurobipy import Model, GRB

# Create a new model
m = Model("advertising_optimization")

# Create variables
newspaper_ads = m.addVar(vtype=GRB.INTEGER, name="newspaper_ads")
tv_ads = m.addVar(vtype=GRB.INTEGER, name="tv_ads")

# Set objective function
m.setObjective(30000 * newspaper_ads + 50000 * tv_ads, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2500 * newspaper_ads + 5000 * tv_ads <= 200000, "budget_constraint")
m.addConstr(newspaper_ads >= 12, "newspaper_min")
m.addConstr(newspaper_ads <= 24, "newspaper_max")
m.addConstr(tv_ads >= 10, "tv_min")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal exposure: {m.objVal}")
    print(f"Number of newspaper advertisements: {newspaper_ads.x}")
    print(f"Number of television advertisements: {tv_ads.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

