
from gurobipy import *

# Create a new model
m = Model("Beverage_Company_Optimization")

# Define variables
x1 = m.addVar(lb=12, ub=24, vtype=GRB.INTEGER, name="newspaper_advertisements")
x2 = m.addVar(lb=10, vtype=GRB.INTEGER, name="television_advertisements")

# Set the objective function
m.setObjective(30000*x1 + 50000*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2500*x1 + 5000*x2 <= 200000, "budget_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of newspaper advertisements: {x1.x}")
    print(f"Number of television advertisements: {x2.x}")
    print(f"Maximum exposure: {m.objVal}")
else:
    print("No optimal solution found")
