
import gurobipy as gp

# Create a new model
model = gp.Model("Media_Selection")

# Define variables
x1 = model.addVar(lb=12, ub=24, vtype=gp.GRB.INTEGER, name="newspaper_advertisements")
x2 = model.addVar(lb=10, vtype=gp.GRB.INTEGER, name="television_advertisements")

# Objective function: Maximize exposure
model.setObjective(30000*x1 + 50000*x2, gp.GRB.MAXIMIZE)

# Budget constraint
model.addConstr(2500*x1 + 5000*x2 <= 200000, name="budget_constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Newspaper Advertisements: {x1.varValue}")
    print(f"Television Advertisements: {x2.varValue}")
    print(f"Maximum Exposure: {30000*x1.varValue + 50000*x2.varValue}")
else:
    print("The model is infeasible.")
