
import gurobipy as gp

# Create a new model
model = gp.Model("Pizza Optimization")

# Create variables
pizza_a = model.addVar(vtype=gp.GRB.CONTINUOUS, name="pizza_a")  # Number of Pizza A
pizza_b = model.addVar(vtype=gp.GRB.CONTINUOUS, name="pizza_b")  # Number of Pizza B


# Set objective function
model.setObjective(3 * pizza_a + 4 * pizza_b, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(4 * pizza_a + 5 * pizza_b <= 600, "mozzarella_constraint")
model.addConstr(5 * pizza_a + 3 * pizza_b <= 500, "american_constraint")
model.addConstr(pizza_a >= 0, "pizza_a_nonnegative")
model.addConstr(pizza_b >= 0, "pizza_b_nonnegative")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Pizza A: {pizza_a.x}")
    print(f"Number of Pizza B: {pizza_b.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

