
from gurobipy import *

# Create a new model
model = Model("Pizza_Optimization")

# Define variables
x1 = model.addVar(vtype=GRB.CONTINUOUS, name="Pizza_A", lb=0)
x2 = model.addVar(vtype=GRB.CONTINUOUS, name="Pizza_B", lb=0)

# Set the objective function
model.setObjective(3*x1 + 4*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(4*x1 + 5*x2 <= 600, "Mozzarella_Cheese_Constraint")
model.addConstr(5*x1 + 3*x2 <= 500, "American_Cheese_Constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Pizza A: {x1.x}")
    print(f"Pizza B: {x2.x}")
    print(f"Total Profit: {model.ObjVal}")
else:
    print("No optimal solution found")
