
import gurobi

def pizza_shop_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="Pizza_A", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="Pizza_B", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Set the objective function
    model.setObjective(3*x1 + 4*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4*x1 + 5*x2 <= 600, name="mozzarella_constraint")
    model.addConstr(5*x1 + 3*x2 <= 500, name="american_cheese_constraint")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Pizza A: {x1.varValue}")
        print(f"Pizza B: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

pizza_shop_problem()
