
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("supplement_optimization")

# Create variables
sd = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="SD")  # Number of SD pills
ld = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="LD")  # Number of LD pills


# Set objective function: Minimize the total cost
m.setObjective(1 * sd + 1.5 * ld, GRB.MINIMIZE)

# Add constraints:
m.addConstr(1 * sd + 2 * ld >= 15, "calcium_req")  # Calcium requirement
m.addConstr(4 * sd + 1 * ld >= 20, "iron_req")    # Iron requirement


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Cost: ${m.objVal}")
    print(f"Number of SD pills: {sd.x}")
    print(f"Number of LD pills: {ld.x}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

