
from gurobipy import *

# Create a new model
m = Model("John_Supplementation")

# Add variables to the model
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="SD_pills", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="LD_pills", lb=0)

# Set the objective function
m.setObjective(1*x1 + 1.5*x2, GRB.MINIMIZE)

# Add constraints to the model
m.addConstr(x1 + 2*x2 >= 15, "Calcium_Constraint")
m.addConstr(4*x1 + x2 >= 20, "Iron_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of SD pills: {x1.x}")
    print(f"Number of LD pills: {x2.x}")
    print(f"Total cost: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
