
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', lb=0, vtype=gurobi.GRB.CONTINUOUS)  # SD pills
    x2 = model.addVar(name='x2', lb=0, vtype=gurobi.GRB.CONTINUOUS)  # LD pills

    # Objective function: Minimize 1*x1 + 1.5*x2
    model.setObjective(1*x1 + 1.5*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(1*x1 + 2*x2 >= 15, name='calcium_constraint')
    model.addConstr(4*x1 + 1*x2 >= 20, name='iron_constraint')

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
