
import gurobipy as gp

# Create a new model
model = gp.Model("Furniture Production")

# Create variables
regular_tables = model.addVar(vtype=gp.GRB.CONTINUOUS, name="regular_tables")
standing_tables = model.addVar(vtype=gp.GRB.CONTINUOUS, name="standing_tables")


# Set objective function
model.setObjective(150 * regular_tables + 180 * standing_tables, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(regular_tables <= 25, "Team A Capacity")
model.addConstr(standing_tables <= 50, "Team B Capacity")
model.addConstr(regular_tables + standing_tables <= 60, "Machine Capacity")
model.addConstr(regular_tables >= 0, "Regular Table Non-Negativity")
model.addConstr(standing_tables >= 0, "Standing Table Non-Negativity")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found. Objective Value: {model.objVal}")
    print(f"Regular Tables: {regular_tables.x}")
    print(f"Standing Tables: {standing_tables.x}")

elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

