
from gurobipy import *

# Create a new model
m = Model("Furniture_Company_Profit")

# Define variables
x1 = m.addVar(name="regular_tables", vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name="standing_tables", vtype=GRB.INTEGER, lb=0)

# Set objective function: Maximize profit
m.setObjective(150*x1 + 180*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 25, name="regular_table_limit")
m.addConstr(x2 <= 50, name="standing_table_limit")
m.addConstr(x1 + x2 <= 60, name="woodworking_machine_limit")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular tables: {x1.x}")
    print(f"Standing tables: {x2.x}")
    print(f"Total profit: ${150*x1.x + 180*x2.x:.2f}")
else:
    print("No optimal solution found")
