
import gurobipy as gp

# Create a new model
model = gp.Model("Furniture_Production")

# Define variables
x1 = model.addVar(name="regular_tables", lb=0, ub=25, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="standing_tables", lb=0, ub=50, vtype=gp.GRB.INTEGER)

# Objective function: Maximize profit
model.setObjective(150*x1 + 180*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 <= 25, name="team_A_capacity")
model.addConstr(x2 <= 50, name="team_B_capacity")
model.addConstr(x1 + x2 <= 60, name="woodworking_machine_capacity")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Produce {x1.varValue} regular tables and {x2.varValue} standing tables.")
    print(f"Maximum profit: ${150*x1.varValue + 180*x2.varValue}")
else:
    print("No optimal solution found.")
