
import gurobipy as gp

# Create a new model
m = gp.Model("Carrot Farming")

# Create variables
x1 = m.addVar(lb=0, name="Danvers")  # Acres of Danvers carrots
x2 = m.addVar(lb=0, name="Nantes")  # Acres of Nantes carrots

# Set objective function
m.setObjective(600*x1 + 300*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 150, "Land")  # Land constraint
m.addConstr(2.5*x1 + 3.7*x2 <= 300, "Labor")  # Labor constraint
m.addConstr(100*x1 + 200*x2 <= 20000, "Maintenance")  # Maintenance cost constraint

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Acres of Danvers carrots: {x1.x}")
    print(f"Acres of Nantes carrots: {x2.x}")
    print(f"Maximum Net Revenue: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

