
from gurobipy import *

# Create a new model
m = Model("Carrot_Farming")

# Add variables
x1 = m.addVar(lb=0, name="Danvers_Carrots")
x2 = m.addVar(lb=0, name="Nantes_Carrots")

# Set the objective function
m.setObjective(600*x1 + 300*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2.5*x1 + 3.7*x2 <= 300, "Labor_Constraint")
m.addConstr(100*x1 + 200*x2 <= 20000, "Maintenance_Costs_Constraint")
m.addConstr(x1 + x2 <= 150, "Total_Land_Constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Acres of Danvers carrots: {x1.x}")
    print(f"Acres of Nantes carrots: {x2.x}")
    print(f"Maximum net revenue: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
