
import gurobi

def solve_optimization_problem():
    # Create a new model
    m = gurobi.Model()

    # Define the variables
    x1 = m.addVar(name="Danvers_carrots", lb=0)
    x2 = m.addVar(name="Nantes_carrots", lb=0)

    # Objective function
    m.setObjective(600 * x1 + 300 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(x1 + x2 <= 150, name="land_constraint")
    m.addConstr(2.5 * x1 + 3.7 * x2 <= 300, name="labor_constraint")
    m.addConstr(100 * x1 + 200 * x2 <= 20000, name="maintenance_constraint")

    # Optimize the model
    m.optimize()

    # Print the solution
    if m.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Acres of Danvers carrots: {x1.varValue}")
        print(f"Acres of Nantes carrots: {x2.varValue}")
        print(f"Max revenue: {m.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
